File: /adapters/cursor/examples/generate-ui-input.md

# Example — Generate UI Input (Free Edition)

This example demonstrates how to generate an Input component
using SaaS OS Free Edition rules.

---

## Objective

Create or update a `ui-input` component that strictly follows the
SaaS OS Input contract.

---

## Required Authority

Before prompting Cursor, confirm this file exists:

SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-input.md

This contract is authoritative.

If the contract is missing, STOP.

---

## Prompt to Use in Cursor

Read:
- SaaS-OS-Free-v1.0/docs/engineering/contracts/Contract — ui-input.md

Task:
Create or overwrite the file:

components/ui-input.tsx

Rules:
- Follow the contract exactly.
- Do not invent validation logic.
- Do not add implicit behavior.
- Do not add new props or variants.
- Do not add internal state unless the contract defines it.
- Use SaaS OS token variables only.
- Preserve semantic HTML (use <input>).

If any requirement is unclear, STOP and ask.

Output:
- Write changes directly to components/ui-input.tsx
- Do not output explanation text unless explicitly requested.

---

## Validation Checklist

After generation, confirm:

- No hardcoded colors or spacing
- No invented validation rules
- No additional props beyond the contract definition
- Token variables are used consistently
- Input remains a semantic <input> element

If violations exist:
1. Reject the output
2. Tighten the prompt
3. Regenerate

Manual patching is discouraged.